package gov.va.med.mhv.rxrefill.data.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.rxrefill.data.model.RxTrackingEmailNotificationStatus;

@Repository
public interface RxTrackingEmailNotifStatusRepository extends JpaRepository<RxTrackingEmailNotificationStatus, Long>{
	
	@Query("from RxTrackingEmailNotificationStatus as rts " + 
				          " where rts.userprofileId = :userProfileId " +
				          " and rts.stationNumber = :stationNumber " +
				          " and rts.prescriptionNumber = :prescriptionNumber " +
				          " and rts.status = '0'" +
				          " and rts.createdDate >= sysdate-3 ")
	public List<RxTrackingEmailNotificationStatus> getRxTrackingEmailNotifStatus(@Param("userProfileId") Long userProfileId,
			@Param("stationNumber") String stationNumber,@Param("prescriptionNumber") String prescriptionNumber);

}
